#!/bin/sh

#Conf dir/file definition
FILE_SYSLOGNG_SVR_INFO=/etc/synosyslog/server.conf

BIN_SYNO_SERVICECFG=/usr/syno/sbin/synoservicecfg
BIN_SYSLOGNG_MAIL=/usr/syno/sbin/synosyslogmail
BIN_SYSLOGNG_SVRCTL=/usr/syno/sbin/synosyslogsvrctl

KEY_SERVICE_ACC="syslog-acc"
KEY_SERVICE_ARCHIVE="syslog-archive"
KEY_SERVICE_BSD="syslog-bsd"
KEY_SERVICE_IETF="syslog-ietf"

PackageInfoGet(){
    SYSLOGNG_PKG_NAME="LogCenter"
    SYSLOGNG_PKG_VERSION="1.0"
    SYSLOGNG_PKG_VENDOR="Synology Inc."
    SYSLOGNG_PKG_MODVER="2.0"
}

ServiceInfoGet(){
    if [ -f "${FILE_SYSLOGNG_SVR_INFO}" ]; then
        SYSLOGNG_SVR_SHARE=`/bin/get_key_value ${FILE_SYSLOGNG_SVR_INFO} server_db_loc`
    else
        echo "Log Center config file does not exist!";
        exit 1;
    fi
}

SvrShareCheck(){
    if [ "" != "${SYSLOGNG_SVR_SHARE}" -a "${CHK_SHARE}" = "${SYSLOGNG_SVR_SHARE}" ]; then
        IS_SVR_SHARE=1;
    else
        IS_SVR_SHARE=0;
    fi
}

SyslogServiceLocSet(){
    RESULT_LOCSET=`${BIN_SYSLOGNG_SVRCTL} --cmdtype=SHARESET --share=${SHARE_NAME}`
}

# Service control
SyslogServiceEnable(){
    SVR_ENABLE=`${BIN_SYNO_SERVICECFG} --is-enable $1`

    if [ "0" = "$?" ]; then
        ${BIN_SYNO_SERVICECFG} --soft-start $1
    fi
}
SyslogServiceDisable(){
    SVR_ENABLE=`${BIN_SYNO_SERVICECFG} --is-enable $1`

    if [ "1" = "$?" ]; then
        ${BIN_SYNO_SERVICECFG} --soft-stop $1
    fi
}

# Mailing relative functions
SyslogMailShareRename(){
    RESULT_MAIL=`${BIN_SYSLOGNG_MAIL} --mailtype=SHARE_RENAME --share=${SYSLOGNG_SVR_SHARE}`
}
SyslogMailShareRemove(){
    RESULT_MAIL=`${BIN_SYSLOGNG_MAIL} --mailtype=SHARE_REMOVE --share=${SYSLOGNG_SVR_SHARE}`
}
SyslogMailShareEncMount(){
    RESULT_MAIL=`${BIN_SYSLOGNG_MAIL} --mailtype=SHARE_ENCMNT --share=${SYSLOGNG_SVR_SHARE}`
}
SyslogMailShareEncUnmount(){
    RESULT_MAIL=`${BIN_SYSLOGNG_MAIL} --mailtype=SHARE_ENCUNMNT --share=${SYSLOGNG_SVR_SHARE}`
}
